define("core/dynamic_tabs",["exports","jquery","core/templates","core/loadingicon","core/notification","core/pending","core/str","core/local/repository/dynamic_tabs","core_form/changechecker"],(function(_exports,_jquery,_templates,_loadingicon,_notification,_pending,_str,_dynamic_tabs,_changechecker){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Dynamic Tabs UI element with AJAX loading of tabs content
   *
   * @module      core/dynamic_tabs
   * @copyright   2021 David Matamoros <davidmc@moodle.com> based on code from Marina Glancy
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_jquery=_interopRequireDefault(_jquery),_templates=_interopRequireDefault(_templates),_notification=_interopRequireDefault(_notification),_pending=_interopRequireDefault(_pending);const SELECTORS={dynamicTabs:".dynamictabs",activeTab:".dynamictabs .nav-link.active",allActiveTabs:'.dynamictabs .nav-link[data-bs-toggle="tab"]:not(.disabled)',tabContent:".dynamictabs .tab-pane [data-tab-content]",tabToggle:'a[data-bs-toggle="tab"]',tabPane:".dynamictabs .tab-pane",forTabName:tabName=>'.dynamictabs [data-tab-content="'.concat(tabName,'"]'),forTabId:tabName=>'.dynamictabs [data-bs-toggle="tab"][href="#'.concat(tabName,'"]')};let watchedFormDirtyNotification=!1;_exports.init=()=>{if(document.querySelectorAll(SELECTORS.tabToggle).forEach((tabToggle=>{tabToggle.addEventListener("show.bs.tab",(event=>{if((0,_changechecker.isAnyWatchedFormDirty)())return event.preventDefault(),event.stopPropagation(),void(watchedFormDirtyNotification||(watchedFormDirtyNotification=!0,_notification.default.saveCancelPromise((0,_str.getString)("changesmade"),(0,_str.getString)("changesmadereallygoaway"),(0,_str.getString)("confirm"),{triggerElement:tabToggle}).then((()=>{(0,_changechecker.resetAllFormDirtyStates)(),tabToggle.dispatchEvent(new Event("click",{bubbles:!0}))})).catch((()=>{})).finally((()=>{watchedFormDirtyNotification=!1}))));const previousTabName=getActiveTabName();if(previousTabName){document.querySelector(SELECTORS.forTabName(previousTabName)).textContent=""}})),tabToggle.addEventListener("shown.bs.tab",(()=>{const tabPane=document.getElementById(tabToggle.getAttribute("href").replace(/^#/,""));tabPane&&loadTab(tabPane.id)}))})),!openTabFromHash()){const tabs=document.querySelector(SELECTORS.allActiveTabs);if(tabs)openTab(tabs.getAttribute("aria-controls"));else{const tabPane=document.querySelector(SELECTORS.tabPane);tabPane&&(tabPane.classList.add("active","show"),loadTab(tabPane.getAttribute("id")))}}};const getActiveTabName=()=>{const element=document.querySelector(SELECTORS.activeTab);return(null==element?void 0:element.getAttribute("aria-controls"))||null},loadTab=tabName=>{var _ref,_tabName;tabName=null!==(_ref=null!==(_tabName=tabName)&&void 0!==_tabName?_tabName:getActiveTabName())&&void 0!==_ref?_ref:(()=>{const element=document.querySelector(SELECTORS.tabContent);return(null==element?void 0:element.dataset.tabContent)||null})();const tab=document.querySelector(SELECTORS.forTabName(tabName));if(!tab)return;const pendingPromise=new _pending.default("core/dynamic_tabs:loadTab:"+tabName);(0,_loadingicon.addIconToContainer)(tab).then((()=>{let tabArgs={...tab.dataset};return delete tabArgs.tabClass,delete tabArgs.tabContent,(0,_dynamic_tabs.getContent)(tab.dataset.tabClass,JSON.stringify(tabArgs))})).then((response=>Promise.all([_jquery.default.parseHTML(response.javascript,null,!0).map((node=>node.innerHTML)).join("\n"),_templates.default.renderForPromise(response.template,JSON.parse(response.content))]))).then((_ref2=>{let[responseJs,{html:html,js:js}]=_ref2;return _templates.default.replaceNodeContents(tab,html,js+responseJs)})).then((()=>pendingPromise.resolve())).catch(_notification.default.exception)},openTab=tabName=>{const tab=(tabName=>document.querySelector(SELECTORS.forTabId(tabName)))(tabName);return!!tab&&(loadTab(tabName),tab.classList.add("active"),(tabName=>document.getElementById(tabName))(tabName).classList.add("active","show"),!0)},openTabFromHash=()=>{const hash=document.location.hash;return!!hash.match(/^#\w+$/g)&&openTab(hash.replace(/^#/g,""))}}));

//# sourceMappingURL=dynamic_tabs.min.js.map